<?php
define('WP_USE_THEMES', true);
require __DIR__ . '/../wp-blog-header.php';
get_header();
?>

<div class="custom-page">

    <!doctype html>
    <html>

    <head>
        <meta name="viewport" content="width=device-width,initial-scale=1.0,minimum-scale=1,maximum-scale=1,user-scalable=0" />
        <meta charset="UTF-8">
        <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
        <meta http-equiv="Pragma" content="no-cache">
        <meta http-equiv="Expires" content="0">

        <title>FAST Booking Engine</title>

        <!-- Add a quick inline CSS rule to hide the original selects -->
        <style>
            .search-noa-input,
            .search-nok-input,
            .search-nor-input {
                display: none !important;
                /* hidden so your new dropdown is used */
            }
        </style>
    </head>

    <body>
        <div class="fast-obe-enq searchForm">
            <!-- Find Your Best Rooms- Top Section -->
            <div class="top-section">
                <div class="everly-container everly-wrapper">
                    <div class="heading">
                        <h1 class="txt-white">Find Your Best Rooms</h1>
                    </div>

                    <div class="form-content">
                        <!-- Row 1: Arrival, Departure, # of night -->
                        <div class="booking-form-row">
                            <!-- Arrival -->
                            <div class="booking-form-group">
                                <h4>Arrival</h4>
                                <div class="input-wrapper">
                                    <input class="search-arr-input" name="arrival" type="text" maxlength="15" />
                                    <div class="material-icons btn-dt btn-search-arr-input"></div>
                                </div>
                            </div>

                            <!-- Departure -->
                            <div class="booking-form-group">
                                <h4>Departure</h4>
                                <div class="input-wrapper search-dep-input0">
                                    <input class="search-dep-input" name="departure" type="text" maxlength="15" />
                                    <div class="material-icons btn-dt btn-search-dep-input"></div>
                                </div>
                            </div>

                            <!-- Number of nights -->
                            <div class="booking-form-group">
                                <h4># of night</h4>
                                <select class="search-night-input" name="night">
                                    <option value="1">1</option>
                                    <option value="2">2</option>
                                    <option value="3">3</option>
                                    <option value="4">4</option>
                                    <option value="5">5</option>
                                    <option value="6">6</option>
                                    <option value="7">7</option>
                                    <option value="8">8</option>
                                    <option value="9">9</option>
                                    <option value="10">10</option>
                                </select>
                            </div>
                        </div>
                        <div class="booking-form-row2">
                            <!-- Row 2: # of room/adult/kid + Special Code, in one row. -->
                            <!-- LEFT col: Single dropdown, with hidden selects behind the scenes -->
                            <div class="booking-form-group2 input-wrapper">
                                <!-- The "label" for # of room, adult, kid -->
                                <div style="margin-bottom: 5px;">
                                    <h4>Rooms & Guest</h4>
                                </div>

                                <!-- Original hidden selects so your JS remains intact -->
                                <select class="txt-input search-noa-input" name="noa">
                                    <option value="1">1</option>
                                    <option value="2">2</option>
                                    <option value="3">3</option>
                                    <option value="4">4</option>
                                    <option value="5">5</option>
                                    <option value="6">6</option>
                                    <option value="7">7</option>
                                    <option value="8">8</option>
                                    <option value="9">9</option>
                                    <option value="10">10</option>

                                </select>
                                <select class="txt-input search-nok-input" name="nok">
                                    <option value="0">0</option>
                                    <option value="1">1</option>
                                    <option value="2">2</option>
                                    <option value="3">3</option>
                                    <option value="4">4</option>
                                    <option value="5">5</option>
                                    <option value="6">6</option>
                                    <option value="7">7</option>
                                    <option value="8">8</option>
                                    <option value="9">9</option>
                                    <option value="10">10</option>

                                </select>
                                <select class="txt-input search-nor-input" name="nor">
                                    <option value="1">1</option>
                                    <option value="2">2</option>
                                    <option value="3">3</option>
                                    <option value="4">4</option>
                                    <option value="5">5</option>
                                    <option value="6">6</option>
                                    <option value="7">7</option>
                                    <option value="8">8</option>
                                    <option value="9">9</option>
                                    <option value="10">10</option>

                                </select>

                                <!-- The single text input (Rooms, Adults, Kids) -->
                                <input
                                    type="text"
                                    id="roomsGuestSummary"
                                    class="txt-input"
                                    style="
                                    cursor: pointer;
                                    width: 100%;
                                    box-sizing: border-box;
                                    padding-right: 35px; /* for arrow icon */
                                    "
                                    value="1 Room, 1 Adult, 0 Kids"
                                    readonly
                                    onclick="document.getElementById('roomsGuestPanel').style.display='block';" />
                                <!-- Arrow icon on the right -->
                                <span class="material-icons">
                                    expand_more
                                </span>

                                <!-- The dropdown with plus/minus for rooms, adults, kids -->
                                <div id="roomsGuestPanel">
                                    <!-- Rooms row -->
                                    <div style="display:flex; justify-content:space-between; margin-bottom:10px;">
                                        <label>
                                            <h4>Rooms</h4>
                                        </label>
                                        <div>
                                            <button type="button" onclick="decRooms()">–</button>
                                            <span id="roomCount">1</span>
                                            <button type="button" onclick="incRooms()">+</button>
                                        </div>
                                    </div>
                                    <!-- Adults row -->
                                    <div style="display:flex; justify-content:space-between; margin-bottom:10px;">
                                        <label>Adults</label>
                                        <div>
                                            <button type="button" onclick="decAdults()">–</button>
                                            <span id="adultCount">1</span>
                                            <button type="button" onclick="incAdults()">+</button>
                                        </div>
                                    </div>
                                    <!-- Kids row -->
                                    <div style="display:flex; justify-content:space-between;">
                                        <label>Kids</label>
                                        <div>
                                            <button type="button" onclick="decKids()">–</button>
                                            <span id="kidCount">0</span>
                                            <button type="button" onclick="incKids()">+</button>
                                        </div>
                                    </div>
                                </div>
                            </div><!-- end col-8 -->

                            <!-- RIGHT col: Special Code -->
                            <div class="booking-form-group2">
                                <h4>Special Code</h4>

                                <div class="input-wrapper special-code-input0">
                                    <input class="txt-input special-code-input" name="code" type="text" maxlength="50" />
                                </div>
                            </div>

                        </div>
                        <!-- Search button row -->
                        <div class="flx-nw" style="margin-top:20px;">
                            <div class="flx-nw btn1 btn-search0 hide-ico">
                                <div class="material-icons btn-search"></div>
                                <div class="btn-t0" style="font-weight: 400;">Search Now</div>
                            </div>
                        </div>
                    </div><!-- end .search-g1 -->

                </div>
            </div>

            <!-- Available rates- Below Section -->
            <div class="everly-container">
                <div class="avail-rate0 everly-wrapper" id="availableRate" style="display: none;">
                    <div class="avail-rate-t1">Available rates</div>
                    <div class="search-g1 rate-il0 search-rs-container" style="margin: 0;">
                        <div></div>
                    </div>
                </div>

                <!-- Template div for rates & slideshow items -->
                <div class="template-div everly-wrapper" style="display:none;">
                    <div class="rate-item0">
                        <div class="flx-nw flx-mobile-reset">
                            <div class="col-5" style="padding: 0; max-width: 100% !important; width: 100% !important;">
                                <img style="object-fit: cover;" />
                                <div class="btn-room-gallery">Room photos</div>
                            </div>
                            <div class="rate-info col-7" style="max-width: 100% !important; width: 100% !important;">
                                <div class="rate-desc"></div>
                                <div class="long-desc"></div>
                                <div class="flx-nw">
                                    <div class="rt-desc0">Room type:</div>
                                    <div class="rt-desc"></div>
                                </div>
                                <div>
                                    <div class="rate-t3">Room features</div>
                                    <div class="rtf"></div>
                                </div>
                                <div>
                                    <div class="rate-t3">Rate inclusions</div>
                                    <div class="rf"></div>
                                </div>
                                <div class="flx-nw rate-t0 col-9">
                                    <div class="allow-cxl"></div>
                                    <div class="allow-amend"></div>
                                </div>
                                <div class="fr">
                                    <div class="amt0 flx-nw">
                                        <div class="curr-code"></div>
                                        <div class="amt"></div>
                                    </div>
                                    <div class="flx-nw btn1 btn-bk0" style="width: 130px; justify-content: center;">
                                        <div class="btn-t0">Book</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="fade slideshow-item0">
                        <img />
                    </div>
                </div>
            </div>

            <!-- Slideshow Modal -->
            <div id="slideshowslide-modal" class="slide-modal slideshow-list0" style="display: none;">
                <div class="slide-modal-content">
                    <span id="closeBtn" class="btn-slide-close">&times;</span>
                    <div class="slideshow-container slideshow-il0">
                        <div class="modal-image-wrapper"></div>
                        <a class="btn-slide-prev" style="color: #FFFFFF;">❮</a>
                        <a class="btn-slide-next" style="color: #FFFFFF;">❯</a>
                    </div>
                </div>
            </div>
        </div><!-- end .fast-obe-enq -->

        <?php include 'layout/tail.php'; ?>