/*
06-Mar-2024,lhw-
*/


//====================== Header ========================================================

function enqForm() {}

// Change the container from .fast-obe-enq to .fast-obe-amend
enqForm.getContainer = () => {
	return $(".fast-obe-amend");
};

enqForm.init = () => {
	const c0 = enqForm.getContainer();
	
	// Menu-related click handlers (login, signup, profile, etc.)
	celUI.click(c0, [
		[
			"btn-amend-bk0",
			() => {
				window.location = getBookingUrl() + "/amend?ts=" + getNowString();
			},
		],
		[
			"btn-sign-up0",
			() => {
				window.location = getBookingUrl() + "/signup?ts=" + getNowString();
			},
		],
		[
			"btn-bk-profile0",
			() => {
				window.location = getBookingUrl() + "/memb-profile?ts=" + getNowString();
			},
		],
		[
			"btn-bk-msg0",
			() => {
				window.location = getBookingUrl() + "/memb-mailbox?ts=" + getNowString();
			},
		],
		[
			"btn-bk-hist0",
			() => {
				window.location = getBookingUrl() + "/booking-list?ts=" + getNowString();
			},
		],
		[
			"btn-login0",
			() => {
				// If currently labeled "logout", then call logout; otherwise go to login page
				if (
					isStrEqual(
						text_get_val(c0.find(".btn-login0 .btn-t0")),
						"logout"
					)
				) {
					let mpa1 = app.get_mpa1();
					if (mpa1) {
						ajaxCall({
							check_status: false,
							p: {
								c: "my-acct",
								a: "logout",
								data: {
									sess_id: mpa1.b,
								},
							},
							on_success: (d2) => {
								data.remove("mpa11");
								window.location =
									 getBookingUrl() + "/?ts=" + getNowString();
							},
							on_fail: () => {
								data.remove("mpa11");
								window.location =
									 getBookingUrl() + "/?ts=" + getNowString();
							},
						});
					} else {
						window.location =  getBookingUrl() + "/?ts=" + getNowString();
					}
				} else {
					window.location =  getBookingUrl() + "/login?ts=" + getNowString();
				}
			},
		],
	]);

	// Membership check for toggling menu items (logout vs login, etc.)
	const mpa1 = app.get_mpa1();
	if (mpa1 && mpa1.b) {
		let ime = app.get_id();
		if (ime) {
			// Hide sign-up group, show member set
			c0.find(".g-set").hide();
			c0.find(".memb-set").show();

			// Change Login button to Logout
			text_set_val(c0.find(".btn-login0 .btn-t0"), "Logout");

			// Show greeting in .ime3
			text_set_val(c0.find(".ime3"), "Helo " + ime);

			// Load any unread message count
			enqForm.load_notif_cnt();
		}
	}
};

// Load unread message count for the mailbox menu icon
enqForm.load_notif_cnt = () => {
	ajaxCall({
		p: {
			c: "bk-op",
			a: "msg-unread-cnt",
			data: {
				db_id: db_id,
				sess_id: app.get_id2(),
			},
		},
		check_status: false,
		on_success: (d2) => {
			const c0 = $(".btn-bk-msg0");
			let c2 = c0.find(".unread-cnt");
			if (c2.length == 0) {
				c2 = $('<div class="unread-cnt"></div>');
				c0.append(c2);
			}

			let i2 = arrLen(d2.data) > 0 ? toInt(d2.data[0].count) : 0;
			text_set_val(c2, i2);
			hide_input(c0, [["unread-cnt", i2 == 0]]);
		},
		on_fail: () => {},
	});
};

// Initialize
$(() => {
	(async () => {
		await app.chk_mpa1();
		enqForm.init();
	})();
});


//====================== End Header ========================================================
function amendBk() {}
amendBk.curr_o = null;

amendBk.getContainer = () => {
    return $('.fast-obe-amend');
};

amendBk.init = () => {
    const c0 = amendBk.getContainer();
    amendBk.curr_o = null;

    celUI.click(c0,
        [
            ['btn-restart0',
                () => {
                    if (getParam('ref_no')) {
                        window.location =  getBookingUrl() + "/booking-list?ts=" + getNowString();
                    }
                    else {
                        window.location = getBookingUrl() + "/?ts=" + getNowString();
                    }
                }],
            ['btn-search-bk0', amendBk.on_search_bk_click],
            ['btn-cxl-bk0', amendBk.on_cxl_click],
            ['btn-chg-dt0', amendBk.on_amend_click],
        ]);

    let ref_no = getParam('ref_no');
    let s2;
    if (ref_no) {
        text_set_val(c0.find('.search-ref-no-input'), decodeURI(ref_no));
        amendBk.on_search_bk_click();
        s2 = 'Bookings';
    }
    else {
        s2 = 'Make new booking';
    }
    text_set_val(c0.find('.btn-restart0 .btn-t0'), s2);

    const sid = app.get_id2();
    if (sid) {
        c0.find('.search-email-input').closest('.email0').find('.compulsory-mark').removeClass('compulsory-mark');
        c0.find('.email0').hide();
    }
    else {
        c0.find('.email0').show();
    }
};

//------------------------------------------------------------------------------
amendBk.on_search_bk_click = () => {
    if (!celClickOnce.acqLock('amendBk.on_search_bk_click')) {
        return;
    }

    const unlock = () => {
        celClickOnce.release('amendBk.on_search_bk_click');
    };

    const c0 = amendBk.getContainer();

    const sid = app.get_id2();
    if (!sid) {
        if (text_is_blank(c0.find('.search-email-input'), 'Please key in your email address')) {
            unlock();
            return;
        }
    }

    if (text_is_blank(c0.find('.search-ref-no-input'), 'Please key in the booking #')) {
        unlock();
        return;
    }

    //-------------------------
    const data = {
        db_id: db_id,
        sess_id: app.get_id2(),
        web_ref_no: text_get_val(c0.find('.search-ref-no-input')),
        email: text_get_val(c0.find('.search-email-input')).trim().toLowerCase(),
    };

    ajaxCall({
        p: {
            c: 'bk-op',
            a: 'bk-submit-get',
            data: data,
        },
        on_success: (d2) => {
            celestial.currency_symbol = d2.data.curr_code || '$';
            text_set_val(c0.find('.curr-code'), celestial.currency_symbol);

            amendBk.curr_o = null;
            if (arrLen(d2.data.bk) == 0) {
                // rec not found, restart the process.
                msgbox.show('Cannot find the booking');
            }
            else {
                c0.find('.bk-dtl').show();

                // load data
                const o2 = d2.data.bk[0];
                amendBk.curr_o = o2;

                o2.ci_dt = toDate(o2.ci_dt);
                o2.co_dt = toDate(o2.co_dt);
                o2.no_of_adult = toInt(o2.no_of_adult);
                o2.no_of_kid = toInt(o2.no_of_kid);
                o2.no_of_room = toInt(o2.no_of_room);

                const day_cnt = dateDiff.inDays(o2.ci_dt, o2.co_dt);
                let pymt_status, payable_lbl, hide_axn;

                if (toInt(o2.pymt_status) == '1') {
                    if (isStrEqual(o2.status, 'uci')) {
                        pymt_status = 'Pay upon check in';
                        payable_lbl = 'Total payable';
                    }
                    else if (isStrEqual(o2.status, 'cxl')) {
                        pymt_status = 'CANCELLED';
                        payable_lbl = 'Total payable';
                        hide_axn = true;
                    }
                    else {
                        pymt_status = 'SUCCESS';
                        payable_lbl = 'Paid amount';
                    }
                }
                else {
                    pymt_status = 'FAILED';
                    payable_lbl = 'Amount';
                }

                text_set_val(c0,
                    [
                        ['period', fmtDateRange(o2.ci_dt, o2.co_dt, 'dd')],
                        ['non', ' ' + day_cnt.toString() + ' night' + (day_cnt > 1 ? 's' : '')],
                        ['noa', o2.no_of_adult.toString() + ' adult' + (o2.no_of_adult > 1 ? 's' : '')],
                        ['nok', o2.no_of_kid.toString() + ' kid' + (o2.no_of_kid > 1 ? 's' : '')],
                        ['nor', o2.no_of_room.toString() + ' room' + (o2.no_of_room > 1 ? 's' : '')],
                        ['payable', formatValue(toDbl(o2.net_amt), 'm2')],
                        ['bk-mod', formatValue(toDate(o2.pymt_update_on), 'dt')],
                        ['user-eml', o2.user_email],
                        ['ref-no', o2.web_ref_no],
                        ['pymt-status', pymt_status],
                        ['payable2', payable_lbl],
                    ]);

                if (toInt(o2.pymt_status) == '1') {
                    c0.find('.payable0').show();
                }

                //-------------------------
                let c3 = c0.find('.allow-cxl')
                if (toInt(o2.allow_cxl) == 1) {
                    text_set_val(c3, `Allow cancellation. (Charges: ${celestial.currency_symbol}${formatValue(toDbl(o2.cxl_chg_amt), 'm2')})`);
                    c0.find('.btn-cxl-bk0').show();
                }
                else {
                    text_set_val(c3, 'Not allow cancellation');
                    c0.find('.btn-cxl-bk0').hide();
                }
                c3 = c0.find('.allow-amend')
                if (toInt(o2.allow_amend) == 1) {
                    text_set_val(c3, `Allow amendment. (Charges: ${celestial.currency_symbol}${formatValue(toDbl(o2.amend_chg_amt), 'm2')})`);
                    c0.find('.btn-chg-dt0').show();
                }
                else {
                    text_set_val(c3, 'Not allow amendment');
                    c0.find('.btn-chg-dt0').hide();
                }

                //-------------------------
                if (hide_axn
                    || (toInt(o2.pymt_status) == 0)
                    || (o2.ci_dt < (new Date))
                ) {
                    c0.find('.bk-axn0').hide();
                }
                else {
                    c0.find('.bk-axn0').show();
                }
            }

            unlock();
        },
        on_fail: () => {
            unlock();
        }
    });
};

//------------------------------------------------------------------------------
amendBk.on_cxl_click = () => {
    if (!amendBk.curr_o) {
        return;
    }

    if (isStrEqual(amendBk.curr_o.status, 'cxl')) {
        msgbox.err('The booking has already been cancelled');
        return;
    }

    if (toInt(amendBk.curr_o.allow_cxl) == 0) {
        msgbox.err(`Cancellation cannot be done on booking ref #${amendBk.curr_o.web_ref_no}. Please review the terms and conditions for this booking.`);
        return;
    }

    if (toInt(amendBk.curr_o.pymt_status) == 0) {
        msgbox.err(`Cancellation cannot be done on booking ref #${amendBk.curr_o.web_ref_no} because no payment has been made.`);
        return;
    }

    if (toDbl(amendBk.curr_o.cxl_chg_amt) > 0) {
        msgbox.show(`Please contact the hotel on canceling this booking ref #${amendBk.curr_o.web_ref_no}.`);
        return;
    }

    //-------------------------
    if (!celClickOnce.acqLock('amendBk.on_cxl_click')) {
        return;
    }

    const web_ref_no = amendBk.curr_o.web_ref_no;
    const c0 = amendBk.getContainer();
    const unlock = () => {
        celClickOnce.release('amendBk.on_cxl_click');
    };

    msgbox.confirm(`Click OK to cancel the booking`,
        () => {
            const data = {
                db_id: db_id,
                sess_id: app.get_id2(),
                web_ref_no: text_get_val(c0.find('.search-ref-no-input')),
                email: text_get_val(c0.find('.search-email-input')),
            };

            ajaxCall({
                p: {
                    c: 'bk-op',
                    a: 'bk-cxl',
                    data: data,
                },
                on_success: (d2) => {
                    msgbox.show(`The booking ${web_ref_no} has been cancelled`);
                    amendBk.curr_o = null;

                    c0.find('.bk-dtl').hide();
                    text_set_val(c0.find('.search-ref-no-input'), '');
                    text_set_val(c0.find('.search-email-input'), '');

                    unlock();
                },
                on_fail: () => {
                    unlock();
                }
            });
        });
};


//------------------------------------------------------------------------------
amendBk.on_amend_click = () => {
    if (!amendBk.curr_o) {
        return;
    }

    if (isStrEqual(amendBk.curr_o.status, 'cxl')) {
        msgbox.err('Amendment is not allowed because the booking has already been cancelled');
        return;
    }

    if (toInt(amendBk.curr_o.allow_amend) == 0) {
        msgbox.err(`Amendment cannot be done on booking ref #${amendBk.curr_o.web_ref_no}. Please review the terms and conditions for this booking.`);
        return;
    }

    if (toInt(amendBk.curr_o.pymt_status) == 0) {
        msgbox.err(`Amendment cannot be done on booking ref #${amendBk.curr_o.web_ref_no} because no payment has been made.`);
        return;
    }

    //-------------------------
    if (!celClickOnce.acqLock('amendBk.on_amend_click')) {
        return;
    }

    const unlock = () => {
        celClickOnce.release('amendBk.on_amend_click');
    };

    msgbox.confirm(`Click OK to continue amending the staying period`,
        () => {
            // save the curr_o info, then
            // nav to enquiry page
            window.location = getBookingUrl() + "/?ts=" + getNowString() + "&eid=" + amendBk.curr_o.resv_id;
        });
}; 

//------------------------------------------------------------------------------
$(() => {
    amendBk.init();
});
