/*
06-Mar-2024,lhw-
*/


//==============================================================================

function bkForm() { }
bkForm.udf_list = null;
bkForm.curr_o = null;
bkForm.eid_state = 0;
bkForm.eid_o = null;


bkForm.getContainer = () => {
    return $('.fast-obe-bk');
};

bkForm.init = () => {
    const c0 = bkForm.getContainer();
    bkForm.eid_state = 0;
    bkForm.eid_o = null;

    (async () => {
        await bkForm.validate_eid();
        await bkForm.load_country();
        await bkForm.load_udf();
        await bkForm.load_data();

        if (bkForm.eid_state == 0) {
            await bkForm.load_profile();
        }

        // [UPDATE] 2024-12-17, AL - bk-form.js: -
        const special_code = getParam('sc');

        if (special_code && !isStrEmpty(special_code)) {
            c0.find('.promo-code2').text('Special code: ');
            c0.find('.promo-code-input').val(special_code);
            c0.find('.promo-code-input').prop('disabled', true);
            c0.find('.btn-validate-promo-code0')[0].style.display = 'none';
        }
    })();


    celUI.click(c0,
        [
            ['btn-pay-now0', bkForm.on_pay_now_click],
            ['btn-validate-promo-code0', bkForm.on_validate_promo_code_click],
            ['btn-restart0', bkForm.on_restart_click],
            ['view-tnc0', bkForm.on_view_tnc_click],

        ]);

    celUI.change(c0,
        [
            ['promo-code-input', bkForm.on_validate_promo_code_click],
        ]);

};

//------------------------------------------------------------------------------
bkForm.load_data = () => {
    return new Promise((resolve, reject) => {
        const data = {
            db_id: db_id,
            sess_id: app.get_id2(),
            resv_id: getParam('id'),
        };

        ajaxCall({
            p: {
                c: 'bk-op',
                a: 'bk-presubmit-get',
                data: data,
            },
            on_success: (d2) => {
                bkForm.curr_o = null;

                if (arrLen(d2.data) == 0) {
                    // the pre-submit data is gone. navigate to the rate searching screen.
                    window.location = getBookingUrl() + "/?ts=" + getNowString();
                    return;
                }
                else {
                    // load pre-submit data
                    const c0 = bkForm.getContainer();
                    const o2 = d2.data[0];
                    bkForm.curr_o = o2;

                    o2.ci_dt = toDate(o2.ci_dt);
                    o2.co_dt = toDate(o2.co_dt);
                    o2.no_of_adult = toInt(o2.no_of_adult);
                    o2.no_of_kid = toInt(o2.no_of_kid);
                    o2.no_of_room = toInt(o2.no_of_room);

                    const day_cnt = dateDiff.inDays(o2.ci_dt, o2.co_dt);

                    //-------------------------
                    let final_net_amt = toDbl(o2.net_amt);
                    if (bkForm.eid_o) {
                        // for amending a bk, if the new amt < old amt, final amt=0.
                        const orig_net_amt = bkForm.eid_o.net_amt;
                        final_net_amt += bkForm.eid_o.amend_chg_amt;
                        if (orig_net_amt >= final_net_amt) {
                            final_net_amt = 0;
                        }
                        else {
                            final_net_amt -= orig_net_amt;
                        }
                    }
                    //-------------------------

                    text_set_val(c0,
                        [
                            ['period', fmtDateRange(o2.ci_dt, o2.co_dt, 'dd')],
                            ['non', ' ' + day_cnt.toString() + ' night' + (day_cnt > 1 ? 's' : '')],
                            ['noa', o2.no_of_adult.toString() + ' adult' + (o2.no_of_adult > 1 ? 's' : '')],
                            ['nok', o2.no_of_kid.toString() + ' kid' + (o2.no_of_kid > 1 ? 's' : '')],
                            ['nor', o2.no_of_room.toString() + ' room' + (o2.no_of_room > 1 ? 's' : '')],
                            ['payable', formatValue(toDbl(o2.net_amt), 'm2')],
                            ['amend-net-amt', formatValue(final_net_amt, 'm2')],
                        ]);

                    let c3 = c0.find('.allow-cxl')
                    if (toInt(o2.allow_cxl) == 1) {
                        text_set_val(c3, 'Allow cancellation');
                    }
                    else {
                        text_set_val(c3, 'Not allow cancellation');
                    }
                    c3 = c0.find('.allow-amend')
                    if (toInt(o2.allow_amend) == 1) {
                        text_set_val(c3, 'Allow amendment');
                    }
                    else {
                        text_set_val(c3, 'Not allow amendment');
                    }

                    // show rates
                    const il0 = c0.find('.rate-il0 > div');
                    const opt = {
                        c0: c0,
                        cls: 'rate-item0',
                    };
                    const ts = getNowString();

                    celLoop.each(d2.data[0].rate_list, (o2) => {
                        celUI.clone(opt, o2);

                        text_set_val(opt.c2,
                            [
                                ['rate-desc', o2.rate_desc],
                                ['amt', formatValue(toDbl(o2.amt0), 'm2')],
                            ]);

                        const img = o2.img_file_url || o2.rt_img_file_url;
                        opt.c2.find('img').attr('src', `${_base_url}q?c=img&f=${img}&ts=${ts}`);

                        il0.append(opt.c2);
                    });
                }

                resolve();
            },
            on_fail: () => {
                resolve();
            }
        });
    });
};

//------------------------------------------------------------------------------
bkForm.load_udf = () => {
    return new Promise((resolve, reject) => {
        const data = {
            db_id: db_id,
            sess_id: app.get_id2(),
            resv_id: getParam('id'),
        };

        ajaxCall({
            p: {
                c: 'bk-op',
                a: 'sys-set',
                data: data,
            },
            on_success: (d2) => {
                const c0 = bkForm.getContainer();
                celestial.currency_symbol = d2.data.curr_code || '$';
                text_set_val(c0.find('.curr-code'), celestial.currency_symbol);

                bkForm.udf_list = d2.data.udf;

                if (arrLen(d2.data.udf) > 0) {
                    const opt_udf = {
                        c0: c0,
                        cls: 'udf-item0'
                    };

                    const udf = d2.data.udf[0];
                    const udf_il = c0.find('.udf0');
                    udf_il.html('');

                    celLoop.runBetween(0, 9, (idx2) => {
                        const idx_str = idx2.toString();
                        if (!isStrEmpty(udf['udf_text' + idx_str])) {
                            celUI.clone(opt_udf);
                            opt_udf.c2.addClass('idx-' + idx_str);

                            text_set_val(opt_udf.c2,
                                [
                                    ['udf-text', udf['udf_text' + idx_str] + ':'],
                                ]);

                            if (toInt(udf['udf_comp' + idx_str]) == 1) {
                                opt_udf.c2.find('.udf-text').addClass('compulsory-mark');
                            }

                            const dt = toInt(udf['udf_type' + idx_str]);
                            const input_c30 = opt_udf.c2.find('.udf-val');
                            let c3;

                            if (dt == 1) {
                                // numeric
                                c3 = $('<input type="text" class="txt-input"/>');
                                input_c30.append(c3);
                                text_accept_numeric_only(c3);
                            }
                            else if (dt == 2) {
                                // date
                                input_c30.addClass('flx-nw');
                                c3 = $('<input type="text" class="txt-input"/><div class="material-icons btn-dt"></div>');
                                input_c30.append(c3);
                                dt_make(c3);
                            }
                            else if (dt == 3) {
                                //complex/cbo
                                c3 = $('<select class="txt-input"></select>');
                                input_c30.append(c3);

                                const items = (udf['udf_opt' + idx_str] || '').split(',');
                                if (arrLen(items) > 0) {
                                    cbo_add_item(c3, '--Select--', '');
                                    celLoop.each(items, (a2) => {
                                        cbo_add_item(c3, a2, a2);
                                    });
                                }
                            }
                            else {
                                //textbox
                                c3 = $('<input type="text" class="txt-input" maxlength="255"/>');
                                input_c30.append(c3);
                            }

                            udf_il.append(opt_udf.c2);
                        }
                    });
                }

                resolve();
            },
            on_fail: () => {
                resolve();
            }
        });
    });
};

//------------------------------------------------------------------------------
bkForm.load_country = () => {
    return new Promise((resolve, reject) => {
        const data = {
            db_id: db_id,
            sess_id: app.get_id2(),
        };

        ajaxCall({
            p: {
                c: 'bk-op',
                a: 'country',
                data: data,
            },
            on_success: (d2) => {
                const c0 = bkForm.getContainer();
                const c2 = c0.find('.nationality-input');
                cbo_clear(c2);
                cbo_add_item(c2, '--Select--', '');

                celLoop.each(d2.data, (o2) => {
                    cbo_add_item(c2, o2.country, o2.country_id);
                });

                resolve();
            },
            on_fail: () => {
                resolve();
            }
        });
    });
};

//------------------------------------------------------------------------------
bkForm.on_validate_promo_code_click = () => {
    const c0 = bkForm.getContainer();

    const data = {
        db_id: db_id,
        sess_id: app.get_id2(),
        resv_id: getParam('id'),
        promo_code: text_get_val(c0.find('.promo-code-input'))
    };

    ajaxCall({
        p: {
            c: 'bk-op',
            a: 'bk-presubmit-set-promo',
            data: data,
        },
        on_success: (d2) => {
            if (arrLen(d2.data) == 0) {
                msgbox.err('Invalid promo code');
            }
            else {
                const o2 = d2.data[0];
                text_set_val(c0,
                    [
                        ['payable', formatValue(toDbl(o2.net_amt), 'm2')],
                    ]);
            }

        },
    });
};

//------------------------------------------------------------------------------
bkForm.on_pay_now_click = () => {
    if (!celClickOnce.acqLock('bkForm.on_pay_now_click')) {
        return;
    }

    const unlock = () => {
        celClickOnce.release('bkForm.on_pay_now_click');
    };

    const c0 = bkForm.getContainer();
    const data = {
        db_id: db_id,
        sess_id: app.get_id2(),
        resv_id: getParam('id'),
        orig_resv_id: ((bkForm.eid_state == 1) ? bkForm.eid_o.resv_id : null)
    };

    if (bkForm.eid_state != 1) {
        const l2 = [
            ['f_name', 'f-name-input', 'First name cannot be blank', null],
            ['l_name', 'l-name-input', 'Last name cannot be blank', null],
            ['email', 'email-input', 'Email address cannot be blank', 'email'],
            ['mobile_phone', 'mobile-phone-input', null, null],
            ['nationality', 'nationality-input', 'Nationality cannot be blank', 'cbo'],
        ];

        let err;
        celLoop.each(l2, (a2) => {
            let v2;
            if (a2[3] == 'cbo') {
                v2 = cbo_get_val(c0.find('.' + a2[1]));
            }
            else if (a2[3] == 'email') {
                v2 = text_get_val(c0.find('.' + a2[1])).trim();
            }
            else {
                v2 = text_get_val(c0.find('.' + a2[1])).trim();
            }

            if (a2[2] && isStrEmpty(v2)) {
                msgbox.show(a2[2]);
                celUI.focusInput(c0.find('.' + a2[1]));
                err = true;
                return false;
            }

            if (a2[3] == 'email') {
                if (!is_valid_email(v2)) {
                    msgbox.show('Invalid email address');
                    celUI.focusInput(c0.find('.' + a2[1]));
                    err = true;
                    return false;
                }

                v2 = v2.trim().toLowerCase();
            }

            data[a2[0]] = v2;
        });

        if (err) {
            unlock();
            return;
        }

        // capture & validate udf
        if (arrLen(bkForm.udf_list) > 0) {
            const udf = bkForm.udf_list[0];
            const udf_il = c0.find('.udf0');

            celLoop.runBetween(0, 9, (idx2) => {
                const idx_str = idx2.toString();
                if (!isStrEmpty(udf['udf_text' + idx_str])) {
                    const udf_row = udf_il.find('.idx-' + idx_str);
                    const dt = toInt(udf['udf_type' + idx_str]);
                    let v2;

                    if (dt == 1) {
                        // numeric
                        v2 = toInt(text_get_val(udf_row.find('input')));
                    }
                    else if (dt == 2) {
                        // date
                        v2 = toSysDate(dt_get_val(udf_row.find('input')));
                    }
                    else if (dt == 3) {
                        //complex/cbo
                        v2 = cbo_get_val(udf_row.find('select'));
                    }
                    else {
                        //textbox
                        v2 = text_get_val(udf_row.find('input')).trim();
                    }

                    // if compulsory
                    if ((toInt(udf['udf_comp' + idx_str]) == 1) && (!v2 || isStrEmpty(v2))) {
                        msgbox.show(`Please fill in the value for "${udf['udf_text' + idx_str]}"`);
                        err = true;
                        return false;
                    }

                    data['udf_val' + idx_str] = v2;
                }
            });
        }

        if (err) {
            unlock();
            return;
        }
    }

    if (!chk_get_val(c0.find('.agree-tnc-input'))) {
        msgbox.show('Please read and tick the "agree the Terms & Conditions" checkbox before clicking on the continue option');
        unlock()
        return;
    }

    //-------------------------
    ajaxCall({
        p: {
            c: 'bk-op',
            a: 'bk-submit',
            data: data,
        },
        on_success: (d2) => {
            unlock();

            if (arrLen(d2.data) == 0) {
                return;
            }

            msgbox.confirm('Please do NOT refresh the browser during the payment process. Click OK to continue next step.',
                () => {
                    let u = _base_url;
                    if (!u.endsWith('/')) {
                        u += '/';
                    }
                    u += 'pymt/checkout';

                    redirectByPost(u,
                        {
                            db_id: db_id,
                            id: getParam('id'),
                        });
                });
        },
        on_fail: () => {
            unlock();
        }
    });
};

//------------------------------------------------------------------------------
bkForm.on_restart_click = () => {
    // [UPDATE] 2024-12-12, AL - bk-form.js: When return, do not show slideshow again.
    window.location = getBookingUrl() + "/?ts=" + getNowString() + '&slideshow=0';
};


//------------------------------------------------------------------------------
bkForm.on_view_tnc_click = () => {
    if (!celClickOnce.acqLock('bkForm.on_view_tnc_click')) {
        return;
    }

    const unlock = () => {
        celClickOnce.release('bkForm.on_view_tnc_click');
    };

    const c0 = bkForm.getContainer();
    c0.find('.bk-form1').hide();
    c0.find('.bk-form2').hide();
    c0.find('.bk-tnc').show();

    c0.find('.btn-close-tnc').off().on('click',
        () => {
            c0.find('.bk-tnc').hide();
            c0.find('.bk-form1').show();
            c0.find('.bk-form2').show();
            unlock();
        });

    const c2 = c0.find('.tnc-dtl');
    c2.html('<div class="spinner"></div>');
    const data = {
        db_id: db_id,
        sess_id: app.get_id2(),
        tnc_code: bkForm.curr_o.tnc_code,
    };

    ajaxCall({
        p: {
            c: 'bk-op',
            a: 'tnc',
            data: data,
        },
        on_success: (d2) => {
            let s2, o2;
            if (arrLen(d2.data) == 0) {
                s2 = bkForm.curr_o.tnc_code;
                o2 = {};
            }
            else {
                o2 = d2.data[0];
                s2 = htmlEscape(o2.tnc_desc || '').replace(/\n/g, '<br>');
            }

            c2.html(s2);

            let c3 = c0.find('.allow-cxl')
            if (toInt(o2.allow_cxl) == 1) {
                text_set_val(c3, 'Allow cancellation');
            }
            else {
                text_set_val(c3, 'Not allow cancellation');
            }
            c3 = c0.find('.allow-amend')
            if (toInt(o2.allow_amend) == 1) {
                text_set_val(c3, 'Allow amendment');
            }
            else {
                text_set_val(c3, 'Not allow amendment');
            }
        },
    });
};


//------------------------------------------------------------------------------
bkForm.validate_eid = async () => {
    bkForm.eid_state = 0;

    return new Promise((resolve, reject) => {
        const eid = getParam('eid');
        if (!eid || eid.trim().length == 0) {
            resolve();
            return;
        }

        ajaxCall({
            p: {
                c: 'bk-op',
                a: 'bk-submit-get',
                data: {
                    db_id: db_id,
                    sess_id: app.get_id2(),
                    resv_id: eid,
                },
            },
            on_success: (d2) => {
                if (arrLen(d2.data.bk) > 0) {
                    const o2 = d2.data.bk[0];

                    if (!(isStrEqual(o2.status, 'cxl')
                        || (toInt(o2.pymt_status) == 0)
                        || (o2.ci_dt < (new Date))
                    )) {
                        // console.log('amend is allowed')
                        bkForm.eid_state = 1;
                        bkForm.eid_o = o2;

                        o2.net_amt = toDbl(o2.net_amt);
                        o2.amend_chg_amt = toDbl(o2.amend_chg_amt);

                        // show the orig bk ref #.
                        const c0 = bkForm.getContainer();
                        text_set_val(c0,
                            [
                                ['orig-ref-no', o2.web_ref_no],
                                ['orig-amt', formatValue(o2.net_amt, 'm2')],
                                ['amend-chg-amt', formatValue(o2.amend_chg_amt, 'm2')],
                            ]);

                        // text_to_span(, 'not-amd-input', '');
                        let c3 = c0.find('.email-input');
                        let c30 = c3.closest('.bk-r1');
                        c3.remove();
                        c30.append($(`<div class="txt-input not-amd-input">${o2.user_email}</div>`));

                        c0.find('.amend-info0').show();
                        c0.find('.amend-notes').show();
                        c0.find('.not-amd').hide();
                    }
                    else {
                        // console.log('amend is not allowed')
                        bkForm.eid_state = 2;
                    }
                }

                resolve();
            },
            on_fail: () => {
                resolve();
            }
        });
    });
};

//------------------------------------------------------------------------------
bkForm.load_profile = async () => {
    return new Promise((resolve, reject) => {

        ajaxCall({
            check_status: false,
            p: {
                c: 'my-acct',
                a: 'profile',
                data: {
                    db_id: db_id,
                    sess_id: app.get_id2(),
                    axn2: 'g',
                },
            },
            on_success: (d2) => {
                if (arrLen(d2.data) > 0) {
                    const c0 = bkForm.getContainer();
                    const o2 = d2.data[0];

                    text_set_val(c0,
                        [
                            ['f-name-input', o2.f_name],
                            ['l-name-input', o2.l_name],
                            ['email-input', o2.email],
                            ['mobile-phone-input', o2.mobile_phone],
                            ['nationality-input', o2.country_id],
                        ]);
                }

                resolve();
            },
            on_fail: () => {
                resolve();
            }
        });
    });
};

//------------------------------------------------------------------------------
$(() => {
    (async () => {
        bkForm.init();
    })();

});



//====================== Header ========================================================

function enqForm() { }


enqForm.getContainer = () => {
    return $(".fast-obe-bk");
};

enqForm.init = () => {
    const c0 = enqForm.getContainer();
    
    // Menu-related click handlers (login, signup, profile, etc.)
    celUI.click(c0, [
        [
            "btn-amend-bk0",
            () => {
                window.location = getBookingUrl() + "/amend?ts=" + getNowString();
            },
        ],
        [
            "btn-sign-up0",
            () => {
                window.location = getBookingUrl() + "/signup?ts=" + getNowString();
            },
        ],
        [
            "btn-bk-profile0",
            () => {
                window.location = getBookingUrl() + "/memb-profile?ts=" + getNowString();
            },
        ],
        [
            "btn-bk-msg0",
            () => {
                window.location = getBookingUrl() + "/memb-mailbox?ts=" + getNowString();
            },
        ],
        [
            "btn-bk-hist0",
            () => {
                window.location = getBookingUrl() + "/booking-list?ts=" + getNowString();
            },
        ],
        [
            "btn-login0",
            () => {
                // If currently labeled "logout", then call logout; otherwise go to login page
                if (
                    isStrEqual(
                        text_get_val(c0.find(".btn-login0 .btn-t0")),
                        "logout"
                    )
                ) {
                    let mpa1 = app.get_mpa1();
                    if (mpa1) {
                        ajaxCall({
                            check_status: false,
                            p: {
                                c: "my-acct",
                                a: "logout",
                                data: {
                                    sess_id: mpa1.b,
                                },
                            },
                            on_success: (d2) => {
                                data.remove("mpa11");
                                window.location =
                                     getBookingUrl() + "/?ts=" + getNowString();
                            },
                            on_fail: () => {
                                data.remove("mpa11");
                                window.location =
                                     getBookingUrl() + "/?ts=" + getNowString();
                            },
                        });
                    } else {
                        window.location =  getBookingUrl() + "/?ts=" + getNowString();
                    }
                } else {
                    window.location =  getBookingUrl() + "/login?ts=" + getNowString();
                }
            },
        ],
    ]);

    // Membership check for toggling menu items (logout vs login, etc.)
    const mpa1 = app.get_mpa1();
    if (mpa1 && mpa1.b) {
        let ime = app.get_id();
        if (ime) {
            // Hide sign-up group, show member set
            c0.find(".g-set").hide();
            c0.find(".memb-set").show();

            // Change Login button to Logout
            text_set_val(c0.find(".btn-login0 .btn-t0"), "Logout");

            // Show greeting in .ime3
            text_set_val(c0.find(".ime3"), "Helo " + ime);

            // Load any unread message count
            enqForm.load_notif_cnt();
        }
    }
};

// Load unread message count for the mailbox menu icon
enqForm.load_notif_cnt = () => {
    ajaxCall({
        p: {
            c: "bk-op",
            a: "msg-unread-cnt",
            data: {
                db_id: db_id,
                sess_id: app.get_id2(),
            },
        },
        check_status: false,
        on_success: (d2) => {
            const c0 = $(".btn-bk-msg0");
            let c2 = c0.find(".unread-cnt");
            if (c2.length == 0) {
                c2 = $('<div class="unread-cnt"></div>');
                c0.append(c2);
            }

            let i2 = arrLen(d2.data) > 0 ? toInt(d2.data[0].count) : 0;
            text_set_val(c2, i2);
            hide_input(c0, [["unread-cnt", i2 == 0]]);
        },
        on_fail: () => { },
    });
};

// Initialize
$(() => {
    (async () => {
        await app.chk_mpa1();
        enqForm.init();
    })();
});


//====================== End Header ========================================================