/*
06-Mar-2024,lhw-
*/
//====================== Header ========================================================

function enqForm() {}


enqForm.getContainer = () => {
	return $(".fast-obe-bk-list");
};

enqForm.init = () => {
	const c0 = enqForm.getContainer();

	// Menu-related click handlers (login, signup, profile, etc.)
	celUI.click(c0, [
		[
			"btn-amend-bk0",
			() => {
				window.location = getBookingUrl() + "/amend?ts=" + getNowString();
			},
		],
		[
			"btn-sign-up0",
			() => {
				window.location = getBookingUrl() + "/signup?ts=" + getNowString();
			},
		],
		[
			"btn-bk-profile0",
			() => {
				window.location = getBookingUrl() + "/memb-profile?ts=" + getNowString();
			},
		],
		[
			"btn-bk-msg0",
			() => {
				window.location = getBookingUrl() + "/memb-mailbox?ts=" + getNowString();
			},
		],
		[
			"btn-bk-hist0",
			() => {
				window.location = getBookingUrl() + "/booking-list?ts=" + getNowString();
			},
		],
		[
			"btn-login0",
			() => {
				// If currently labeled "logout", then call logout; otherwise go to login page
				if (
					isStrEqual(
						text_get_val(c0.find(".btn-login0 .btn-t0")),
						"logout"
					)
				) {
					let mpa1 = app.get_mpa1();
					if (mpa1) {
						ajaxCall({
							check_status: false,
							p: {
								c: "my-acct",
								a: "logout",
								data: {
									sess_id: mpa1.b,
								},
							},
							on_success: (d2) => {
								data.remove("mpa11");
								window.location =
									 getBookingUrl() + "/?ts=" + getNowString();
							},
							on_fail: () => {
								data.remove("mpa11");
								window.location =
									 getBookingUrl() + "/?ts=" + getNowString();
							},
						});
					} else {
						window.location =  getBookingUrl() + "/?ts=" + getNowString();
					}
				} else {
					window.location =  getBookingUrl() + "/login?ts=" + getNowString();
				}
			},
		],
	]);

	// Membership check for toggling menu items (logout vs login, etc.)
	const mpa1 = app.get_mpa1();
	if (mpa1 && mpa1.b) {
		let ime = app.get_id();
		if (ime) {
			// Hide sign-up group, show member set
			c0.find(".g-set").hide();
			c0.find(".memb-set").show();

			// Change Login button to Logout
			text_set_val(c0.find(".btn-login0 .btn-t0"), "Logout");

			// Show greeting in .ime3
			text_set_val(c0.find(".ime3"), "Helo " + ime);

			// Load any unread message count
			enqForm.load_notif_cnt();
		}
	}
};

// Load unread message count for the mailbox menu icon
enqForm.load_notif_cnt = () => {
	ajaxCall({
		p: {
			c: "bk-op",
			a: "msg-unread-cnt",
			data: {
				db_id: db_id,
				sess_id: app.get_id2(),
			},
		},
		check_status: false,
		on_success: (d2) => {
			const c0 = $(".btn-bk-msg0");
			let c2 = c0.find(".unread-cnt");
			if (c2.length == 0) {
				c2 = $('<div class="unread-cnt"></div>');
				c0.append(c2);
			}

			let i2 = arrLen(d2.data) > 0 ? toInt(d2.data[0].count) : 0;
			text_set_val(c2, i2);
			hide_input(c0, [["unread-cnt", i2 == 0]]);
		},
		on_fail: () => {},
	});
};

// Initialize
$(() => {
	(async () => {
		await app.chk_mpa1();
		enqForm.init();
	})();
});


//====================== End Header ========================================================



'use strict';

function bkList() { }
bkList.bk_setting = null;

//------------------------------------------------------------------------------
bkList.getContainer = function () {
    return $('.fast-obe-bk-list');
};

//------------------------------------------------------------------------------
bkList.init0 = function () {

    const c0 = bkList.getContainer();

    (async () => {
        //enable the click handler after the setting has been downloaded
        celUI.click(c0,
            [
                ['bkl-il0', 'btn-download-pdf0', bkList.on_download_pdf_bk_click],
                ['bkl-il0', 'btn-amend-bkl0', bkList.on_amend_click],
                ['bkl-il0', 'btn-send-msg-bkl0', bkList.on_send_msg_bkl_click],

                ['btn-restart0',
                    () => {
                        window.location = getBookingUrl() + "/?ts=" + getNowString();
                    }],
            ]);

    })();

    (async () => {
        await bkList.list();
    })();

};

//---------------------------------------------------------------
bkList.list = function () {
    return new Promise((resolve, reject) => {
        const c0 = bkList.getContainer();

        ajaxCall({
            p: {
                c: 'bk-op',
                a: 'bk-list',
                data: {
                    sess_id: app.get_id2(),
                },
            },
            on_success: (d2) => {
                // show data
                const il0 = c0.find('.bkl-il0 > div');
                il0.html('');

                if (arrLen(d2.data) == 0) {
                    const opt_nd = {
                        c0: c0,
                        cls: 'no-data0',
                    };
                    celUI.clone(opt_nd);
                    il0.append(opt_nd.c2);
                }
                else {
                    const opt = {
                        c0: c0,
                        cls: 'item-div0',
                    };

                    const opt_udf = {
                        c0: c0,
                        cls: 'udf-item0',
                    };

                    celLoop.each(d2.data, (o2) => {
                        celUI.clone(opt, o2);

                        text_set_val(opt.c2,
                            [
                                ['web-ref-no', o2.web_ref_no],
                                ['dt', formatValue(toDate(o2.bk_on), 'dt')],
                                ['stay-period', fmtDateRange(toDate(o2.ci_dt), toDate(o2.co_dt))],
                                ['adult', toInt(o2.no_of_adult)],
                                ['kid', toInt(o2.no_of_kid)],
                                ['no-of-room', toInt(o2.no_of_room)],
                                ['curr-code', o2.curr_code],
                                ['amt', formatValue(toDbl(o2.amt), 'm2')],
                                ['status', o2.resv_status_desc],
                            ]);

                        // pay upon check in.
                        if (toInt(o2.resv_status_id) == 1) {
                            opt.c2.find('.paid-on0').hide();
                        }

                        if (bkList.bk_setting && arrLen(bkList.bk_setting.udf) > 0) {
                            const udf = bkList.bk_setting.udf[0];

                            celLoop.runBetween(0, 9, (idx2) => {
                                const idx_str = idx2.toString();
                                if (!isStrEmpty(udf['udf_text' + idx_str])) {
                                    celUI.clone(opt_udf);

                                    text_set_val(opt_udf.c2,
                                        [
                                            ['.text', udf['udf_text' + idx_str] + ':'],
                                            ['.val', (o2['udf_val' + idx_str] ? o2['udf_val' + idx_str] : '-')]
                                        ]);
                                    opt.c2.find('.udf0').append(opt_udf.c2);
                                }
                            });
                        }

                        il0.append(opt.c2);
                    });
                }

                resolve();
            }
        });
    });
};


//------------------------------------------------------------------------------
bkList.on_download_pdf_bk_click = (e) => {
    const o2 = celUI.getData(e, 'item-div');
    if (!o2) {
        return;
    }

    if (!celClickOnce.acqLock('bkList.on_download_pdf_bk_click')) {
        return;
    }
    const unlock = () => {
        celClickOnce.release('bkList.on_download_pdf_bk_click');
    };

    //-------------------------
    const url = [
        getBaseUrl(),
        `q?c=bk-op&axn=bk-pdf`,
        `&db_id=${o2.co_id}`,
        `&resv_id=${o2.resv_id}`
    ];

    downloadFile(url.join(''), '.pdf', unlock);
};

//------------------------------------------------------------------------------
bkList.on_amend_click = (e) => {
    const o2 = celUI.getData(e, 'item-div');
    if (!o2) {
        return;
    }
    window.location.href = getBookingUrl() + "/amend?ts=" + getNowString() + "&ref_no=" + encodeURIComponent(o2.web_ref_no);
};

//------------------------------------------------------------------------------
bkList.on_send_msg_bkl_click = (e) => {
    const o2 = celUI.getData(e, 'item-div');
    if (!o2) {
        return;
    }

    window.location = getBookingUrl() + "/memb-mailbox?ts=" + getNowString() + "&ref_no=" + encodeURIComponent(o2.web_ref_no) + "&resv_id=" + o2.resv_id;

};



//==============================================================================
$(function () {
    (async () => {
        if (await app.chk_mpa1()) {
            bkList.init0();
        }
        else {
            window.location =  getBookingUrl() + "/?ts=" + getNowString();
        }
    })();
});


