﻿//14-Jul-2022,lhw-
//====================== Header ========================================================

function enqForm() {}

// Change the container from .fast-obe-enq to .fast-obe-amend
enqForm.getContainer = () => {
	return $(".fast-obe-chg-pwd");
};

enqForm.init = () => {
	const c0 = enqForm.getContainer();

	// Menu-related click handlers (login, signup, profile, etc.)
	celUI.click(c0, [
		[
			"btn-amend-bk0",
			() => {
				window.location = getBookingUrl() + "/amend?ts=" + getNowString();
			},
		],
		[
			"btn-sign-up0",
			() => {
				window.location = getBookingUrl() + "/signup?ts=" + getNowString();
			},
		],
		[
			"btn-bk-profile0",
			() => {
				window.location = getBookingUrl() + "/memb-profile?ts=" + getNowString();
			},
		],
		[
			"btn-bk-msg0",
			() => {
				window.location = getBookingUrl() + "/memb-mailbox?ts=" + getNowString();
			},
		],
		[
			"btn-bk-hist0",
			() => {
				window.location = getBookingUrl() + "/booking-list?ts=" + getNowString();
			},
		],
		[
			"btn-login0",
			() => {
				// If currently labeled "logout", then call logout; otherwise go to login page
				if (
					isStrEqual(
						text_get_val(c0.find(".btn-login0 .btn-t0")),
						"logout"
					)
				) {
					let mpa1 = app.get_mpa1();
					if (mpa1) {
						ajaxCall({
							check_status: false,
							p: {
								c: "my-acct",
								a: "logout",
								data: {
									sess_id: mpa1.b,
								},
							},
							on_success: (d2) => {
								data.remove("mpa11");
								window.location =
									 getBookingUrl() + "/?ts=" + getNowString();
							},
							on_fail: () => {
								data.remove("mpa11");
								window.location =
									 getBookingUrl() + "/?ts=" + getNowString();
							},
						});
					} else {
						window.location =  getBookingUrl() + "/?ts=" + getNowString();
					}
				} else {
					window.location =  getBookingUrl() + "/login?ts=" + getNowString();
				}
			},
		],
	]);

	// Membership check for toggling menu items (logout vs login, etc.)
	const mpa1 = app.get_mpa1();
	if (mpa1 && mpa1.b) {
		let ime = app.get_id();
		if (ime) {
			// Hide sign-up group, show member set
			c0.find(".g-set").hide();
			c0.find(".memb-set").show();

			// Change Login button to Logout
			text_set_val(c0.find(".btn-login0 .btn-t0"), "Logout");

			// Show greeting in .ime3
			text_set_val(c0.find(".ime3"), "Helo " + ime);

			// Load any unread message count
			enqForm.load_notif_cnt();
		}
	}
};

// Load unread message count for the mailbox menu icon
enqForm.load_notif_cnt = () => {
	ajaxCall({
		p: {
			c: "bk-op",
			a: "msg-unread-cnt",
			data: {
				db_id: db_id,
				sess_id: app.get_id2(),
			},
		},
		check_status: false,
		on_success: (d2) => {
			const c0 = $(".btn-bk-msg0");
			let c2 = c0.find(".unread-cnt");
			if (c2.length == 0) {
				c2 = $('<div class="unread-cnt"></div>');
				c0.append(c2);
			}

			let i2 = arrLen(d2.data) > 0 ? toInt(d2.data[0].count) : 0;
			text_set_val(c2, i2);
			hide_input(c0, [["unread-cnt", i2 == 0]]);
		},
		on_fail: () => {},
	});
};

// Initialize
$(() => {
	(async () => {
		await app.chk_mpa1();
		enqForm.init();
	})();
});


//====================== End Header ========================================================

'use strict';

function chgPwd() { }

//------------------------------------------------------------------------------
chgPwd.getContainer = function () {
    return getJObject('fast-obe-chg-pwd');
};

//------------------------------------------------------------------------------
chgPwd.init0 = function () {

    setTimeout(() => {
        celUI.focusInput(chgPwd.getContainer(), 'old-pwd-input');
    }, 100);

    const c0 = chgPwd.getContainer();
    c0.find('.pwd-notes .material-icons').removeClass('img-ok').addClass('img-not-met');

    c0.find('.new-pwd-input').off().on('keyup',
        function(e2) {
            app.chk_pwd_pol(chgPwd, chgPwd.getContainer(), e2);
        });

    app.list_pwd_pol(chgPwd, c0);


    celUI.click(c0,
        [
            ['btn-submit-pwd0', chgPwd.on_submit_click],
            ['btn-restart0',
                () => {
                    window.location = getBookingUrl() + "/?ts=" + getNowString();
                }],

        ]);


};

//------------------------------------------------------------------------------
chgPwd.on_submit_click = function () {
    const c0 = chgPwd.getContainer();
    if (text_is_blank(c0.find('.old-pwd-input'), 'Please key in old password')) {
        return;
    }

    if (text_is_blank(c0.find('.new-pwd-input'), 'Please key in new password')) {
        return;
    }

    if (text_is_blank(c0.find('.new-pwd-input2'), 'Please key in re-enter new password')) {
        return;
    }

    const o2 = {};
    text_get_val2(c0, o2,
        [
            ['v0', 'old-pwd-input'],
            ['v1', 'new-pwd-input'],
            ['v2', 'new-pwd-input2'],
        ]);

    if (o2.v1 != o2.v2) {
        msgbox.err('New password is mismatch. Please re-enter');
        highlight_compulsory(c0.find('.new-pwd-input2'));
        celUI.focusInput(c0, 'new-pwd-input2');
        return;
    }

    //-------------------------------
    ajaxCall({
        p: {
            c: 'my-acct',
            a: 'chg-pwd',
            data: {
                db_id: db_id,
                sess_id: app.get_id2(),
                old_pwd: o2.v0,
                pwd: o2.v1
            }
        },
        on_success: function (d3) {
            msgbox.show('The password has been changed');

            // nav back to the prev screen.
            // app.getReturnOption().trigger('click');
        }
    });
};

//==============================================================================
$(function () {
    (async () => {
        if (await app.chk_mpa1()) {
            chgPwd.init0();
        }
        else {
            window.location.href =  getBookingUrl() + "/?ts=" + getNowString();
        }
    })();
});
