/*
06-Mar-2024,lhw-
*/


//====================== Header ========================================================

function enqForm() {}

// Change the container from .fast-obe-enq to .fast-obe-amend
enqForm.getContainer = () => {
	return $(".fast-obe-mb");
};

enqForm.init = () => {
	const c0 = enqForm.getContainer();
	
	// Menu-related click handlers (login, signup, profile, etc.)
	celUI.click(c0, [
		[
			"btn-amend-bk0",
			() => {
				window.location = getBookingUrl() + "/amend?ts=" + getNowString();
			},
		],
		[
			"btn-sign-up0",
			() => {
				window.location = getBookingUrl() + "/signup?ts=" + getNowString();
			},
		],
		[
			"btn-bk-profile0",
			() => {
				window.location = getBookingUrl() + "/memb-profile?ts=" + getNowString();
			},
		],
		[
			"btn-bk-msg0",
			() => {
				window.location = getBookingUrl() + "/memb-mailbox?ts=" + getNowString();
			},
		],
		[
			"btn-bk-hist0",
			() => {
				window.location = getBookingUrl() + "/booking-list?ts=" + getNowString();
			},
		],
		[
			"btn-login0",
			() => {
				// If currently labeled "logout", then call logout; otherwise go to login page
				if (
					isStrEqual(
						text_get_val(c0.find(".btn-login0 .btn-t0")),
						"logout"
					)
				) {
					let mpa1 = app.get_mpa1();
					if (mpa1) {
						ajaxCall({
							check_status: false,
							p: {
								c: "my-acct",
								a: "logout",
								data: {
									sess_id: mpa1.b,
								},
							},
							on_success: (d2) => {
								data.remove("mpa11");
								window.location =
									 getBookingUrl() + "/?ts=" + getNowString();
							},
							on_fail: () => {
								data.remove("mpa11");
								window.location =
									 getBookingUrl() + "/?ts=" + getNowString();
							},
						});
					} else {
						window.location =  getBookingUrl() + "/?ts=" + getNowString();
					}
				} else {
					window.location =  getBookingUrl() + "/login?ts=" + getNowString();
				}
			},
		],
	]);

	// Membership check for toggling menu items (logout vs login, etc.)
	const mpa1 = app.get_mpa1();
	if (mpa1 && mpa1.b) {
		let ime = app.get_id();
		if (ime) {
			// Hide sign-up group, show member set
			c0.find(".g-set").hide();
			c0.find(".memb-set").show();

			// Change Login button to Logout
			text_set_val(c0.find(".btn-login0 .btn-t0"), "Logout");

			// Show greeting in .ime3
			text_set_val(c0.find(".ime3"), "Helo " + ime);

			// Load any unread message count
			enqForm.load_notif_cnt();
		}
	}
};

// Load unread message count for the mailbox menu icon
enqForm.load_notif_cnt = () => {
	ajaxCall({
		p: {
			c: "bk-op",
			a: "msg-unread-cnt",
			data: {
				db_id: db_id,
				sess_id: app.get_id2(),
			},
		},
		check_status: false,
		on_success: (d2) => {
			const c0 = $(".btn-bk-msg0");
			let c2 = c0.find(".unread-cnt");
			if (c2.length == 0) {
				c2 = $('<div class="unread-cnt"></div>');
				c0.append(c2);
			}

			let i2 = arrLen(d2.data) > 0 ? toInt(d2.data[0].count) : 0;
			text_set_val(c2, i2);
			hide_input(c0, [["unread-cnt", i2 == 0]]);
		},
		on_fail: () => {},
	});
};

// Initialize
$(() => {
	(async () => {
		await app.chk_mpa1();
		enqForm.init();
	})();
});


//====================== End Header ========================================================
'use strict';

function membMailbox() { }
membMailbox.curr_reply_list = null;


membMailbox.getContainer = function () {
    return $('.obe-usr-mailbox0');
};

//------------------------------------------------------------------------------
membMailbox.init0 = function () {
    const c0 = membMailbox.getContainer();

    membMailbox.item_list = function() {};
    if (isStrEmpty(getParam('resv_id'))) {

        celItemList({
            po: membMailbox.item_list,
            c0: c0,
            // ct0: null,
            il0: 'item-list',
            // ct_item_div: 'item-div0',
            // ct_no_data: 'no-data',
            // spinner0: c0.find('.al-sb-l'),
            rec_cnt0: null,

            ajax_cmd: 'bk-op',
            ajax_cmd_axn: 'view-inbox',
            big_list: false,

            // the settings for celDataProc()
            data_proc: {
                inject_common_fn: true,
                fmtDateInSysFmt: true,
                fld: {
                    mail_uuid: { c2: 'mail-uuid-input' },
                    subject: { c2: 'subject-input', ic2: 'subject', maxlen: 1000 },
                    created_on: { ic2: 'mod-on', fmt: 'dt'},
                    sender: { ic2: 'sender', },
                },

                onFmtItem2: function (itemObj, o) {
                    text_set_val(itemObj.find('.read-on'), (o.read_on ? formatValue(toDate(o.read_on), 'dt') : 'Not read yet'));
                    text_set_val(itemObj.find('.reply-on'), (o.reply_on ? formatValue(toDate(o.reply_on), 'dt') : 'Not reply yet'));

                }
            },

            // user_pref: null,
            // onInit: function() {},

            onGetListParam: function(p2) {
                p2.data.db_id = db_id;
                p2.data.sess_id = app.get_id2();
                p2.data.axn2 = cbo_get_val(c0.find('.status-input'));
            },

            onList: function(d2) {
                const b = arrLen(d2.data) == 0;
                if (b) {
                    c0.find('.btn-reply-msg0').hide();
                    c0.find('.subject-input').css('background-color', 'lightgray');
                    c0.find('.body-text-input').attr('readonly', true).css('background-color', 'lightgray');
                    c0.find('.msg-seq0').hide();
                }
                else {
                    c0.find('.btn-reply-msg0').show();
                    c0.find('.subject-input').css('background-color', '');
                    c0.find('.body-text-input').attr('readonly', false).css('background-color', '');
                    c0.find('.msg-seq0').show();
                }

                disableInput(c0,
                    [
                        ['subject-input', b],
                    ]);
            },
        });
        membMailbox.item_list.init();


        const il = membMailbox.item_list.getItemListContainer()
        il.off().on('click', '.item-div', membMailbox.on_load_msg);
    }

    celUI.click(c0,
        [
            ['btn-reply-msg0', membMailbox.on_reply_click],
            ['btn-send-msg0',
                () => {
                    (async () => {
                        if (await app.chk_mpa1()) {
                            membMailbox.on_send_click();
                        }
                        else {
                            msgbox.err('Your session has expired. Please logon before replying the message.',
                                () => {
                                    window.location = getBookingUrl() + "/login?ts=" + getNowString();
                                }); 
                        }
                    })();
                }],

            ['btn-nav-to-bkl',
                () => {
                    if (!isStrEmpty(getParam('resv_id'))) {
                        window.location =  getBookingUrl() + "/booking-list?ts=" + getNowString();
                    }
                    else {
                        window.location = getBookingUrl() + "/?ts=" + getNowString();
                    }
                }],

            ['btn-nav-to-home',
                () => {
                    window.location.href = getBookingUrl() + "/?ts=" + getNowString();
                }],
        ]);

    celUI.change(c0,
        [
            ['status-input', membMailbox.ref_list],
        ]);

    //-------------------------
    celUI.updateWindowResize(membMailbox);

    if (!isStrEmpty(getParam('resv_id'))) {
        c0.find('.msg-list').hide();
        c0.find('.entry0').css('width', '100%');
        c0.find('.msg-seq0').hide();
        c0.find('.btn-reply-msg0').hide();
        c0.find('.btn-send-msg0').show();
        c0.find('.btn-nav-to-bkl').show();

        text_set_val(c0,
            [
                ['subject-input', 'Booking #' + decodeURI(getParam('ref_no'))],
                ['body-text-input', ['Helo sir/mdm,', '', '', 'Regards.'].join('\n')],
            ]);

        membMailbox.curr_reply_list = [ {
            resv_id: getParam('resv_id'),
        }];

        celUI.focusInput(c0.find('.subject-input'));
    }
    else {
        c0.find('.btn-nav-to-bkl').hide();
    }

};

//------------------------------------------------------------------------------
membMailbox.onResize = function onresize_obe_msg_set() {
    const h2 = 100;
    const c0 = membMailbox.getContainer();
};

//------------------------------------------------------------------------------
membMailbox.enable_input = (b) => {
    const c0 = membMailbox.getContainer();

    readonly_input(c0,
        [
            ['subject-input', !b],
            ['body-text-input', !b],
        ]);
    // switch the action buttons
    hide_input(c0,
        [
            ['btn-reply-msg0', b],
            ['btn-send-msg0', !b],
            ['sent-on0', b]
        ]);
};

//------------------------------------------------------------------------------

membMailbox.on_reply_click = () => {
    const c0 = membMailbox.getContainer();

    // enable the input.
    membMailbox.enable_input(true);
    // remove the replies
    c0.find('.reply-il0').html('');

    // get the latest msg
    const o2 = membMailbox.curr_reply_list[membMailbox.curr_reply_list.length - 1];

    let c2;
    c2 = c0.find('.body-text-input');
    let body_text = o2.body_text;
    let s2 = [];

    const append_line = (s3) => {
        s3 = s3.toString().split('\n');
        celLoop.each(s3, (s32) => {
            s2.push('>' + s32);
        });
    };

    while (body_text.length > 100) {
        append_line(body_text.substring(0, 100));
        body_text = body_text.substring(100, body_text.length);
    }

    if (body_text.length > 0 && body_text.length <= 100) {
        append_line(body_text);
    }

    s2.push('');
    s2.push('');
    text_set_val(c2, s2.join('\n'));

    c2 = c0.find('.subject-input');
    text_set_val(c2, 'RE:' + o2.subject);

    celUI.focusInput(c2);
};

//------------------------------------------------------------------------------
membMailbox.on_send_click = () => {
    const c0 = membMailbox.getContainer();
    let c2 = c0.find('.subject-input');
    let subject = text_get_val(c2);
    if (isStrEmpty(subject)) {
        msgbox.show('The subject cannot be blank');
        return;
    }

    c2 = c0.find('.body-text-input');
    let body_text = text_get_val(c2);
    if (isStrEmpty(body_text)) {
        msgbox.show('Please write your message');
        return;
    }
    if (body_text.length > 5000) {
        msgbox.show('The message allows 5,000 characters only');
        return;
    }

    if (!celClickOnce.acqLock('membMailbox.on_send_click')) {
        return;
    }

    const unlock = () => {
        celClickOnce.release('membMailbox.on_send_click');
    };

    //-------------------------
    const p2 = {
        c: 'bk-op',
        a: 'msg-send',
        data: {
            db_id: db_id,
            sess_id: app.get_id2(),
            subject: subject,
            body_text: body_text
        }
    };

    const o2 = membMailbox.curr_reply_list[membMailbox.curr_reply_list.length - 1];
    if (o2) {
        p2.data.resv_id = o2.resv_id;
        p2.data.cust_id = o2.cust_id;
        p2.data.reply_to_mail_uuid = o2.mail_uuid;
    }

    // load mail body
    ajaxCall({
        p: p2,
        on_success: (d2) => {
            msgbox.show('Your message has been sent');
            unlock();

            if (isStrEmpty(getParam('resv_id'))) {
                membMailbox.ref_list();
            }
        },
        on_fail: () => {
            unlock();
        }
    });

};

//------------------------------------------------------------------------------
membMailbox.on_load_msg = (e) => {
    const c0 = membMailbox.getContainer();
    const o2 = celUI.getData(e, 'item-div');

    //clear the content
    text_set_val(c0.find('.subject-input'), o2.subject);
    text_set_val(c0.find('.body-text-input'), '');

    text_set_val(c0,
        [
            ['msg-seq', '#1'],
            ['sent-on2', formatValue(toDate(o2.created_on), 'dt')],
            ['subject-input', o2.subject],
            ['body-text-input', ''],
        ]);

    const il = c0.find('.reply-il0');
    il.html('');
    membMailbox.enable_input(false);

    // load mail body
    ajaxCall({
        p: {
            code: 'bk-op',
            axn: 'msg-get',
            data: {
                db_id: db_id,
                sess_id: app.get_id2(),
                mail_uuid: o2.mail_uuid,
                axn2: 'include-all-reply'
            }
        },
        on_success: (d2) => {
            let o3 = (arrLen(d2.data) > 0 ? d2.data[0] : {});
            o3.mail_uuid = o2.mail_uuid;
            membMailbox.curr_reply_list = d2.data;

            text_set_val(c0.find('.body-text-input'), o3.body_text || '');

            if (arrLen(d2.data) > 1) {
                const opt = {
                    c0: c0,
                    cls: 'msg-reply-item0'
                };

                celLoop.each(d2.data, (o3, idx3) => {
                    // skip the first item
                    if (idx3 == 0) {
                        return;
                    }

                    celUI.clone(opt);

                    text_set_val(opt.c2,
                        [
                            ['msg-seq', '#' + (idx3 + 1)],
                            ['sent-on3', formatValue(toDate(o3.created_on), 'dt')],
                            ['subject3', o3.subject],
                            ['body-text3', o3.body_text],
                        ]);

                    il.append(opt.c2);
                });
            }
        },
    });
};

//------------------------------------------------------------------------------
membMailbox.ref_list = () => {

    const c0 = membMailbox.getContainer();
    text_set_val(c0,
        [
            ['subject-input', ''],
            ['body-text-input', ''],
        ]);

    c0.find('.reply-il0').html('');
    membMailbox.curr_reply_list = null;

    membMailbox.item_list.getItemListContainer().html('');
    membMailbox.item_list.list();
    membMailbox.enable_input(false);
};

//==============================================================================
$(function () {
    (async () => {
        if (await app.chk_mpa1()) {
            membMailbox.init0();
        }
        else {
            window.location.href =  getBookingUrl() + "/?ts=" + getNowString();
        }
    })();
});
