/*
06-Mar-2024,lhw-
*/
//====================== Header ========================================================

function enqForm() {}

// Change the container from .fast-obe-enq to .fast-obe-amend
enqForm.getContainer = () => {
	return $(".fast-obe-signup");
};

enqForm.init = () => {
	const c0 = enqForm.getContainer();

	// Menu-related click handlers (login, signup, profile, etc.)
	celUI.click(c0, [
		[
			"btn-amend-bk0",
			() => {
				window.location = getBookingUrl() + "/amend?ts=" + getNowString();
			},
		],
		[
			"btn-sign-up0",
			() => {
				window.location = getBookingUrl() + "/signup?ts=" + getNowString();
			},
		],
		[
			"btn-bk-profile0",
			() => {
				window.location = getBookingUrl() + "/memb-profile?ts=" + getNowString();
			},
		],
		[
			"btn-bk-msg0",
			() => {
				window.location = getBookingUrl() + "/memb-mailbox?ts=" + getNowString();
			},
		],
		[
			"btn-bk-hist0",
			() => {
				window.location = getBookingUrl() + "/booking-list?ts=" + getNowString();
			},
		],
		[
			"btn-login0",
			() => {
				// If currently labeled "logout", then call logout; otherwise go to login page
				if (
					isStrEqual(
						text_get_val(c0.find(".btn-login0 .btn-t0")),
						"logout"
					)
				) {
					let mpa1 = app.get_mpa1();
					if (mpa1) {
						ajaxCall({
							check_status: false,
							p: {
								c: "my-acct",
								a: "logout",
								data: {
									sess_id: mpa1.b,
								},
							},
							on_success: (d2) => {
								data.remove("mpa11");
								window.location =
									 getBookingUrl() + "/?ts=" + getNowString();
							},
							on_fail: () => {
								data.remove("mpa11");
								window.location =
									 getBookingUrl() + "/?ts=" + getNowString();
							},
						});
					} else {
						window.location =  getBookingUrl() + "/?ts=" + getNowString();
					}
				} else {
					window.location =  getBookingUrl() + "/login?ts=" + getNowString();
				}
			},
		],
	]);

	// Membership check for toggling menu items (logout vs login, etc.)
	const mpa1 = app.get_mpa1();
	if (mpa1 && mpa1.b) {
		let ime = app.get_id();
		if (ime) {
			// Hide sign-up group, show member set
			c0.find(".g-set").hide();
			c0.find(".memb-set").show();

			// Change Login button to Logout
			text_set_val(c0.find(".btn-login0 .btn-t0"), "Logout");

			// Show greeting in .ime3
			text_set_val(c0.find(".ime3"), "Helo " + ime);

			// Load any unread message count
			enqForm.load_notif_cnt();
		}
	}
};

// Load unread message count for the mailbox menu icon
enqForm.load_notif_cnt = () => {
	ajaxCall({
		p: {
			c: "bk-op",
			a: "msg-unread-cnt",
			data: {
				db_id: db_id,
				sess_id: app.get_id2(),
			},
		},
		check_status: false,
		on_success: (d2) => {
			const c0 = $(".btn-bk-msg0");
			let c2 = c0.find(".unread-cnt");
			if (c2.length == 0) {
				c2 = $('<div class="unread-cnt"></div>');
				c0.append(c2);
			}

			let i2 = arrLen(d2.data) > 0 ? toInt(d2.data[0].count) : 0;
			text_set_val(c2, i2);
			hide_input(c0, [["unread-cnt", i2 == 0]]);
		},
		on_fail: () => {},
	});
};

// Initialize
$(() => {
	(async () => {
		await app.chk_mpa1();
		enqForm.init();
	})();
});


//====================== End Header ========================================================

//==============================================================================

function setp() {}
setp.curr_o = null;

setp.getContainer = () => {
    return $('.fast-obe-activate');
};

setp.init = () => {
    const c0 = setp.getContainer();

    // console.log('setp_init');
    const p0 = getAllParam();
    c0.show();

    setp.get_user_info = false;

    if (p0.a == 'reg') {
        text_set_val(c0.find('.setp-t0'), 'Activate your account');
    }
    else if (p0.a == 'invite') {
        text_set_val(c0.find('.setp-t0'), 'Accept invitation');
    }

    celUI.click(c0,
        [
            ['btn-restart0',
                () => { 
                    window.location = getBookingUrl() + "/signup?ts=" + getNowString();
                }],

            ['btn-setp-submit', setp.on_submit_click]
        ]);

    c0.find('.setp-div1').hide();


    ajaxCall({
        p: {
            c: 'get-req',
            data: {
                req_id: getParam('id')
            }
        },
        on_success: function (d2) {
            let o2;
            if (arrLen(d2.data) > 0) {
                o2 = d2.data[0];
            }

            if (!o2) {
                setp.show_err('This link is no longer valid. Please request for a new link.');
                return;
            }

            if (o2.is_used == 1) {
                setp.show_err('This link has been used. Please request for a new link.');
                return;
            }

            if (o2.token_exp == 1) {
                setp.show_err('This link has expired. Please request for a new link.');
                return;
            }

            //-------------------------
            c0.find('.setp-div1').show();

            if (p0.a == 'invite') {
                if (toInt(o2.has_acct) == 0) {
                    // the user does not has acct, ask for full reg.
                    setp.get_user_info = (toInt(o2.has_acct) == 0);
                    c0.find('.reg1').show();
                    celUI.focusInput(c0, 'reg-name');
                    setp.chk_p = true;
                }
                else {
                    // the user has acct, skip ask for password.
                    c0.find('.setp-div3').hide();
                }

                c0.find('.setp-msg1').show();
                text_set_val(c0,
                    [
                        ['.invite-fr', o2.inviter],
                        ['.invite-to-db', o2.db_title],
                        ['.btn-setp-submit', 'Accept the invitation'],
                    ]);

            }
            else if (p0.a == 'resetp' || p0.a == 'reg') {
                //11-Oct-2022,lhw-
                setp.chk_p = true;
                setp.get_user_info = false;
            }
            else {
                celUI.focusInput(c0, 'setp-p1');
            }

            // handle pwd policies
            c0.find('.pwd-notes .material-icons').removeClass('img-ok').addClass('img-not-met');
            c0.find('.setp-p1').off().on('keyup',
                function(e2) {
                    app.chk_pwd_pol(setp, c0, e2);
                });
            app.list_pwd_pol(setp, c0);

            c0.find('.setp-g2').hide();
            c0.find('.setp-div').show();
        },

        on_fail: () => {
            setp.show_err('Failed to load the data. Please retry later.');
        }
    });
};

//------------------------------------------------------------------------------
setp.show_err = (s2) => {
    const c0 = setp.getContainer();

    text_set_val(c0.find('.wait-status-t1'), s2);
    c0.find('.setp-g2 .spinner').remove();
    c0.find('.btn-restart0').show();
};


//------------------------------------------------------------------------------
setp.on_submit_click = function () {
    // console.log('setp.on_submit_click');

    let c0 = setp.getContainer();

    if (setp.get_user_info) {
        if (text_is_blank(c0.find('.reg-name'), 'Please key in your full name')) {
            return;
        }
        if (text_is_blank(c0.find('.reg-id'), 'Please key in your login ID')) {
            return;
        }
    }

    let p1;
    if (setp.chk_p) {
        let c1 = c0.find('.setp-p1');
        let c2 = c0.find('.setp-p2');
        if (text_is_blank(c1, 'Please key in your password')) {
            return;
        }

        p1 = text_get_val(c1);

        if (text_is_blank(c2, 'Please re-enter your password')) {
            return;
        }

        let p2 = text_get_val(c2);
        if (p1 != p2) {
            msgbox.err('Password mismatch. Please re-enter your password');
            getJObject(c2).trigger('focus').trigger('select');
            return;
        }
    }

    //-------------------------
    let p0 = getAllParam();
    let ac;
    if (p0.a == 'reg') {
        ac = 'activate';
    }
    else if (p0.a == 'invite') {
        ac = 'accept-invite';
    }
    else {
        ac = 'setp';
    }

    let o2 = {
        pwd: p1,
        req_id: getParam('id')
    };

    if (setp.get_user_info) {
        text_get_val2(c0, o2,
            [
                ['user_name', 'reg-name'],
                ['login_id', 'reg-id'],
            ]);
    }

    ajaxCall({
        queue: true,
        p: {
            code: ac,
            data: o2
        },

        on_success: function (d2) {
            // remove hash & querystring.
            // let u = window.location.href
            //     .replace(window.location.search, '')
            //     .replace(window.location.hash, '');

            // let i;
            // if (p0.a == 'invite') {
            //     if (setp.get_user_info) {
            //         // created acct
            //         i = 104;
            //     }
            //     else {
            //         // continue with logon
            //         i = 103;
            //     }
            // }

            // if (!i) {
            //     i = 102;
            // }

            // u += '?#a=102';
            // u += '?#a=' + i.toString();
            window.location.href = getBookingUrl() + "/login";
            
        }
    });
};

//------------------------------------------------------------------------------
$(() => {
    setp.init();
});
